/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.game;

import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.cca.PlayerShopComponent;
import dev.doctor4t.wathe.index.WatheItems;
import dev.doctor4t.wathe.util.ShopEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface GameConstants {
    public static final int FADE_TIME = 40;
    public static final int FADE_PAUSE = 20;
    public static final int DOOR_AUTOCLOSE_TIME = GameConstants.getInTicks(0, 5);
    public static final Map<class_1792, Integer> ITEM_COOLDOWNS = new HashMap<class_1792, Integer>();
    public static final int JAMMED_DOOR_TIME = GameConstants.getInTicks(1, 0);
    public static final int TIME_TO_DECOMPOSITION = GameConstants.getInTicks(1, 0);
    public static final int DECOMPOSING_TIME = GameConstants.getInTicks(4, 0);
    public static final float MOOD_GAIN = 0.5f;
    public static final float MOOD_DRAIN = 1.0f / (float)GameConstants.getInTicks(4, 0);
    public static final int TIME_TO_FIRST_TASK = GameConstants.getInTicks(0, 30);
    public static final int MIN_TASK_COOLDOWN = GameConstants.getInTicks(0, 30);
    public static final int MAX_TASK_COOLDOWN = GameConstants.getInTicks(1, 0);
    public static final int SLEEP_TASK_DURATION = GameConstants.getInTicks(0, 8);
    public static final int OUTSIDE_TASK_DURATION = GameConstants.getInTicks(0, 8);
    public static final float MID_MOOD_THRESHOLD = 0.55f;
    public static final float DEPRESSIVE_MOOD_THRESHOLD = 0.2f;
    public static final float ITEM_PSYCHOSIS_CHANCE = 0.5f;
    public static final int ITEM_PSYCHOSIS_REROLL_TIME = 200;
    public static final List<ShopEntry> SHOP_ENTRIES = (List)class_156.method_654(new ArrayList(), entries -> {
        entries.add(new ShopEntry(WatheItems.KNIFE.method_7854(), 100, ShopEntry.Type.WEAPON));
        entries.add(new ShopEntry(WatheItems.REVOLVER.method_7854(), 300, ShopEntry.Type.WEAPON));
        entries.add(new ShopEntry(WatheItems.GRENADE.method_7854(), 350, ShopEntry.Type.WEAPON));
        entries.add(new ShopEntry(WatheItems.PSYCHO_MODE.method_7854(), 300, ShopEntry.Type.WEAPON){

            @Override
            public boolean onBuy(@NotNull class_1657 player) {
                return PlayerShopComponent.usePsychoMode(player);
            }
        });
        entries.add(new ShopEntry(WatheItems.POISON_VIAL.method_7854(), 100, ShopEntry.Type.POISON));
        entries.add(new ShopEntry(WatheItems.SCORPION.method_7854(), 50, ShopEntry.Type.POISON));
        entries.add(new ShopEntry(WatheItems.FIRECRACKER.method_7854(), 10, ShopEntry.Type.TOOL));
        entries.add(new ShopEntry(WatheItems.LOCKPICK.method_7854(), 50, ShopEntry.Type.TOOL));
        entries.add(new ShopEntry(WatheItems.CROWBAR.method_7854(), 25, ShopEntry.Type.TOOL));
        entries.add(new ShopEntry(WatheItems.BODY_BAG.method_7854(), 200, ShopEntry.Type.TOOL));
        entries.add(new ShopEntry(WatheItems.BLACKOUT.method_7854(), 200, ShopEntry.Type.TOOL){

            @Override
            public boolean onBuy(@NotNull class_1657 player) {
                return PlayerShopComponent.useBlackout(player);
            }
        });
        entries.add(new ShopEntry(new class_1799((class_1935)WatheItems.NOTE, 4), 10, ShopEntry.Type.TOOL));
    });
    public static final int MONEY_START = 100;
    public static final Function<Long, Integer> PASSIVE_MONEY_TICKER = time -> {
        if (time % (long)GameConstants.getInTicks(0, 10) == 0L) {
            return 5;
        }
        return 0;
    };
    public static final int MONEY_PER_KILL = 100;
    public static final int PSYCHO_MODE_ARMOUR = 1;
    public static final int PSYCHO_TIMER = GameConstants.getInTicks(0, 30);
    public static final int FIRECRACKER_TIMER = GameConstants.getInTicks(0, 15);
    public static final int BLACKOUT_MIN_DURATION = GameConstants.getInTicks(0, 15);
    public static final int BLACKOUT_MAX_DURATION = GameConstants.getInTicks(0, 20);
    public static final int TIME_ON_CIVILIAN_KILL = GameConstants.getInTicks(1, 0);

    public static void init() {
        ITEM_COOLDOWNS.put(WatheItems.KNIFE, GameConstants.getInTicks(1, 0));
        ITEM_COOLDOWNS.put(WatheItems.REVOLVER, GameConstants.getInTicks(0, 10));
        ITEM_COOLDOWNS.put(WatheItems.DERRINGER, GameConstants.getInTicks(0, 1));
        ITEM_COOLDOWNS.put(WatheItems.GRENADE, GameConstants.getInTicks(5, 0));
        ITEM_COOLDOWNS.put(WatheItems.LOCKPICK, GameConstants.getInTicks(3, 0));
        ITEM_COOLDOWNS.put(WatheItems.CROWBAR, GameConstants.getInTicks(0, 10));
        ITEM_COOLDOWNS.put(WatheItems.BODY_BAG, GameConstants.getInTicks(5, 0));
        ITEM_COOLDOWNS.put(WatheItems.PSYCHO_MODE, GameConstants.getInTicks(5, 0));
        ITEM_COOLDOWNS.put(WatheItems.BLACKOUT, GameConstants.getInTicks(3, 0));
    }

    public static int getInTicks(int minutes, int seconds) {
        return (minutes * 60 + seconds) * 20;
    }

    public static interface DeathReasons {
        public static final class_2960 GENERIC = Wathe.id("generic");
        public static final class_2960 KNIFE = Wathe.id("knife_stab");
        public static final class_2960 GUN = Wathe.id("gun_shot");
        public static final class_2960 BAT = Wathe.id("bat_hit");
        public static final class_2960 GRENADE = Wathe.id("grenade");
        public static final class_2960 POISON = Wathe.id("poison");
        public static final class_2960 FELL_OUT_OF_TRAIN = Wathe.id("fell_out_of_train");
    }
}

